;*
;* JAVA LOADER FOR 6502
;*
.MACRO	PSTR	MSG
	JSR	PUTS
	.ASCIIZ	MSG
.ENDMACRO
.MACRO	PSTRLN	MSG
	JSR	PUTSLN
	.ASCIIZ	MSG
.ENDMACRO
;*
;* HARDWARE ADDRESSES
;*
KEYBD	=	$C000
CLRKBD	=	$C010
SPKR	=	$C030
ROMIN	=	$C081
LCBNK2	=	$C083
LCBNK1	=	$C08B
;*
;* HANDY ROM ROUTINES
;*
MONITOR	=	$FF65
HOME	=	$FC58
BELL	=	$FF3A
COUT	=	$FDED
CROUT	=	$FD8E
CROUT1	=	$FD8B
PRBLNK	=	$F948
PRBL2	=	$F94A
PRBYTE	=	$FDDA
PRNTAX	=	$F941
GETLN	=	$FD6A
;*
;* PRODOS
;*
PRODOS	=	$BF00
;*
;* ZERO PAGE LOCATIONS
;*
SRCADDR	=	$DA
DSTADDR	=	$DC
TMP	=	$DE
TMPTR	=	$DE

	.CODE
;*
;* LOAD 64K VM02 OR 128K VM02
;*
ENTRY:	JMP	LOADER		; SET UP ARG PASSING FROM LAUNCHER
	.BYTE	$EE,$EE
	.BYTE	65
ARGSTR:	.BYTE	0
	.RES	64
LOADER:	LDA	#<RELOC
	LDX	#>RELOC
	JSR	MEMSRC
	LDA	#$00
	LDX	#$0C
	JSR	MEMDST
	LDA	#<(BLOAD_END-MOUSE_INIT)
	LDX	#>(BLOAD_END-MOUSE_INIT)
	JSR	MEMCPY
	LDA	#<VM02SMALL
	LDX	#>VM02SMALL
	JSR	MEMSRC
	LDA	#<FILENAME
	LDX	#>FILENAME
	JSR	MEMDST
	LDA	VM02SMALL
	CLC
	ADC	#$01
	LDX	#$00
	JSR	MEMCPY
	LDY	#$00		; STUFF ARG STRING INTO INPUT BUFFER
:	LDA	ARGSTR,Y
	STA	$01FF,Y
	CPY	ARGSTR
	BEQ	JMP_RLOAD
	INY
	BNE	:-
JMP_RLOAD:	LDX	#$FE
	TXS
	JMP	$0C00
VM02SMALL:	.BYTE	4,"VM02"
;*
;* PRINT ASCIIZ STRING FOLLOWING JSR PUTS
;*
PUTS:	LDX	#$00
PUTSIT:	PLA
	STA	TMP
	PLA
	STA	TMP+1
	LDY	#$00
PUTS_LP:	INC	TMP
	BNE	:+
	INC	TMP+1
:	LDA	(TMP),Y
	BEQ	PUTS_EXIT
	JSR	COUT
	JMP	PUTS_LP
PUTS_EXIT:	LDA	TMP+1
	PHA
	LDA	TMP
	PHA
	CPX	#$00
	BEQ	:+
	JMP	CROUT
:	RTS
PUTSLN:	LDX	#$01
	JMP	PUTSIT
;*
;* PRINT STRING IN AX
;*
PRSTR:	STA	TMP
	STX	TMP+1
	LDY	#$00
	LDA	(TMP),Y
	TAX
	INY
PRSTR_LP:	LDA	(TMP),Y
	JSR	COUT
	INY
	DEX
	BNE	PRSTR_LP
	RTS
PRSTRLN:	JSR	PRSTR
	JSR	CROUT
	RTS
;*
;* WAIT FOR KEYPRESS
;*
KBWAIT:	LDA	KEYBD
	BPL	KBWAIT
	LDA	CLRKBD
	RTS
;*
;* SET MEMORY SRC OPERAND
;* ENTRY: AX = ADDRESS
;*
MEMSRC:	STA	SRCADDR
	STX	SRCADDR+1
	RTS
;*
;* SET MEMORY DST OPERAND
;* ENTRY: AX = ADDRESS
;*
MEMDST:	STA	DSTADDR
	STX	DSTADDR+1
	RTS
;*
;* COPY MEMORY
;*
;* ENTRY: SRCADDR = SOURCE ADDRESS
;*        DSTADDR = DESTINATION ADDRESS
;*             AX = LENGTH IN BYTES
;*
MEMCPY:	TAY
	LDA	SRCADDR+1
	CMP	DSTADDR+1
	BEQ	:+
	BCS	FORCPY
	BCC	REVCPY
:	LDA	SRCADDR
	CMP	DSTADDR
	BCS	FORCPY
REVCPY:	TXA			; REVERSE DIRECTION COPY
	CLC
	ADC	SRCADDR+1
	STA	SRCADDR+1
	TXA
	CLC
	ADC	DSTADDR+1
	STA	DSTADDR+1
	INX
	CPY	#$00
	BEQ	:++
	DEY
	BEQ	:+
REVCPY_LOOP:	LDA	(SRCADDR),Y
	STA	(DSTADDR),Y
	DEY
	BNE	REVCPY_LOOP
:	LDA	(SRCADDR),Y		; DO ONE MORE COPY, Y = #$00
	STA	(DSTADDR),Y		; (THIS MAKES FOR A SLIGHTLY FASTER INNER LOOP)
:	DEY			; NOW Y = #$FF
	DEX
	BEQ	:+
	DEC	SRCADDR+1
	DEC	DSTADDR+1
	BNE	REVCPY_LOOP
:	RTS
FORCPY:	TYA			; FORWARD DIRECTION COPY
	EOR	#$FF
	TAY
	INY
	BNE	:+
	DEX
:	LDA	SRCADDR
	STY	SRCADDR
	SEC
	SBC	SRCADDR
	STA	SRCADDR
	LDA	SRCADDR+1
	SBC	#$00
	STA	SRCADDR+1
	LDA	DSTADDR
	STY	DSTADDR
	SEC
	SBC	DSTADDR
	STA	DSTADDR
	LDA	DSTADDR+1
	SBC	#$00
	STA	DSTADDR+1
	INX
FORCPY_LOOP:	LDA	(SRCADDR),Y
	STA	(DSTADDR),Y
	INY
	BNE	FORCPY_LOOP
	DEX
	BEQ	:+
	INC	SRCADDR+1
	INC	DSTADDR+1
	BNE	FORCPY_LOOP
:	RTS
;*
;* RELOC FROM HERE
;*
RELOC:
	.ORG	$0C00
;*
;* MOUSE INIT ROUTINES.  MUST HAPPEN HERE BECAUSE II/II+ WILL CLEAR $2000-$4000 FOR 
;* VBL CALCULATION
;*
MOUSE_INIT:	SEI
	LDX	#$20		; LOOK FOR MOUSE
	LDA	#$01
	JSR	SCAN_SLOTS
	BCS	BLOAD
	STX	INITMOUSE+2
	STX	SETMOUSE+2
	LDY	#$19
	LDA	(TMPTR),Y
	STA	INITMOUSE+1
	LDY	#$12
	LDA	(TMPTR),Y
	STA	SETMOUSE+1
	LDX	TMPTR+1
	TXA
	ASL
	ASL
	ASL
	ASL
	STA	TMPTR
	TAY
INITMOUSE:	JSR	$C400
	LDX	TMPTR+1
	LDY	TMPTR
	LDA	#$08		; TURN MOUSE OFF, VBL ACTIVE
SETMOUSE:	JSR	$C400
;*
;* READ BINARY FILE
;* ENTRY: AX = POINTER TO FILE NAME/ADDRESS
;*
BLOAD:	LDA	#<FILENAME
	STA	OPENPARMS+1		; SET FILENAME BUFFER
	LDA	#>FILENAME
	STA	OPENPARMS+2
	LDA	#$00		; SET DATA ADDRESS
	STA	READPARMS+2
	LDA	#$10
	STA	READPARMS+3
	JSR	PRODOS
	.BYTE	$C8		; OPEN FILE
	.ADDR	OPENPARMS
	BCS	:+
	LDA	OPENPARMS+5
	STA	GETEOFPARMS+1
	STA	READPARMS+1
	STA	CLOSEPARMS+1
	JSR	PRODOS
	.BYTE	$D1		; GET EOF (FILE LEN)
	.ADDR	GETEOFPARMS
	BCS	:+
	LDA	GETEOFPARMS+2
	STA	READPARMS+4
	LDA	GETEOFPARMS+3
	STA	READPARMS+5
	JSR	PRODOS
	.BYTE	$CA		; READ FILE
	.ADDR	READPARMS
	BCS	:+
	JSR	PRODOS
	.BYTE	$CC		; CLOSE FILE
	.ADDR	CLOSEPARMS
:	JMP	$1000		; JUMP TO VM02
OPENPARMS:	.BYTE	$03
	.ADDR	$0000		; PATH ADDR
	.ADDR	$B000		; BUFF ADDR
	.BYTE	$00		; REF NUM
GETEOFPARMS:	.BYTE	$02
	.BYTE	$00		; REF NUM
	.BYTE	$00,$00,$00		; EOF L/M/H
READPARMS:	.BYTE	$04
	.BYTE	$00		; REF NUM
	.ADDR	$0000		; DATA ADDR
	.ADDR	$0000		; DATA LEN
	.ADDR	$0000		; ACTUAL LEN
CLOSEPARMS:	.BYTE	$01
	.BYTE	$00		; REF NUM
FILENAME:	.RES	65
;
; SCAN SLOTS FOR MATCHING CARD ID
; ENTRY: A = START SLOT SCAN
;        X = CARD ID
; EXIT:  A = SLOT # :: C = 0
;        X = SLOT PAGE
;
SCAN_SLOTS:	ORA	#$C0
	STA	TMPTR+1
	LDA	#$00
	STA	TMPTR
CHKSIG:	LDY	#$05
	LDA	(TMPTR),Y
	CMP	#$38		; LOOK FOR PASCAL COMPAT SIG
	BNE	:+
	LDY	#$07
	LDA	(TMPTR),Y
	CMP	#$18
	BNE	:+
	LDY	#$0B
	LDA	(TMPTR),Y
	CMP	#$01
	BNE	:+
	LDY	#$0C
	TXA			; LOOK FOR MATCHING ID
	CMP	(TMPTR),Y
	BNE	:+
	LDA	TMPTR+1
	TAX
	AND	#$07
	CLC
	RTS
:	INC	TMPTR+1
	LDA	TMPTR+1
	CMP	#$C8
	BCC	CHKSIG
	SEC
	RTS
BLOAD_END	=	*